<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="utf-8" indent="yes" doctype-system="about:legacy-compat"/>
  <xsl:template match="/">
    <html lang="en">
      <head>
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1"/>
        <title>Nmap 扫描报告</title>
        
        <!-- CSS 框架 -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css"/>
        
        <!-- ECharts 图表库 -->
        <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
        
        <style>
          :root {
            --primary-color: #3498db;
            --secondary-color: #2c3e50;
            --success-color: #2ecc71;
            --warning-color: #f39c12;
            --danger-color: #e74c3c;
            --bg-color: #f8f9fa;
            --card-bg: #ffffff;
            --text-color: #212529;
            --border-color: #dee2e6;
            --card-shadow: 0 6px 15px rgba(0,0,0,0.1);
          }
          
          body.dark-mode {
            --bg-color: #1a1d21;
            --card-bg: #23272b;
            --text-color: #f8f9fa;
            --border-color: #444;
            --card-shadow: 0 6px 15px rgba(0,0,0,0.3);
          }
          
          body {
            background-color: var(--bg-color);
            color: var(--text-color);
            padding-top: 70px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            transition: background-color 0.3s, color 0.3s;
          }
          
          .navbar {
            background-color: var(--secondary-color);
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
          }
          
          .card {
            background-color: var(--card-bg);
            border: none;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            margin-bottom: 25px;
            transition: all 0.3s ease;
            overflow: hidden;
          }
          
          .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0,0,0,0.15);
          }
          
          .card-header {
            background: linear-gradient(135deg, var(--primary-color), #2980b9);
            border-bottom: none;
            padding: 15px 20px;
            color: white;
            border-radius: 12px 12px 0 0 !important;
          }
          
          .card-title {
            margin: 0;
            font-weight: 600;
            color: white;
            font-size: 1.2rem;
          }
          
          .table {
            color: var(--text-color);
            border-collapse: separate;
            border-spacing: 0;
          }
          
          .table th {
            background-color: rgba(0,0,0,0.05);
            border-bottom: 2px solid var(--border-color);
            font-weight: 600;
          }
          
          .table-hover tbody tr:hover {
            background-color: rgba(0,0,0,0.03);
          }
          
          body.dark-mode .table-hover tbody tr:hover {
            background-color: rgba(255,255,255,0.05);
          }
          
          .badge {
            font-weight: 500;
            padding: 6px 10px;
            border-radius: 4px;
          }
          
          .target:before {
            content: "";
            display: block;
            height: 70px;
            margin-top: -70px;
            visibility: hidden;
          }
          
          /* 概览卡片美化 */
          .overview-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
          }
          
          .overview-card {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 25px 20px;
            text-align: center;
            box-shadow: var(--card-shadow);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(0,0,0,0.05);
          }
          
          .overview-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0,0,0,0.15);
          }
          
          .overview-card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color), #3498db);
          }
          
          .card-icon {
            width: 60px;
            height: 60px;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(52, 152, 219, 0.1);
            border-radius: 12px;
            font-size: 1.8rem;
            color: var(--primary-color);
          }
          
          .overview-card .stat-value {
            font-size: 2.5rem;
            font-weight: 700;
            margin: 5px 0;
            color: var(--text-color);
            line-height: 1.2;
          }
          
          .overview-card .stat-label {
            font-size: 1rem;
            color: #6c757d;
            margin-top: 5px;
            font-weight: 500;
          }
          
          .overview-card .trend {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 0.85rem;
            margin-top: 10px;
            background: rgba(46, 204, 113, 0.1);
            color: #2ecc71;
          }
          
          .service-tag {
            display: inline-block;
            padding: 4px 10px;
            background: rgba(52, 152, 219, 0.2);
            border-radius: 20px;
            margin: 2px;
            font-size: 0.85rem;
          }
          
          .port-badge {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 60px;
            padding: 5px;
            border-radius: 4px;
            font-weight: 600;
            margin: 2px;
          }
          
          .port-open {
            width: 100%;
            background-color: rgba(46, 204, 113, 0.2);
            color: #2ecc71;
          }
          
          .port-filtered {
            background-color: rgba(243, 156, 18, 0.2);
            color: #f39c12;
          }
          
          .port-closed {
            background-color: rgba(149, 165, 166, 0.2);
            color: #95a5a6;
          }
          
          .vulnerability-indicator {
            height: 8px;
            border-radius: 4px;
            margin-top: 5px;
            background: linear-gradient(90deg, var(--success-color), var(--warning-color), var(--danger-color));
          }
          
          .script-output {
            background-color: rgba(0,0,0,0.05);
            border-left: 3px solid var(--primary-color);
            padding: 12px 15px;
            border-radius: 0 4px 4px 0;
            margin: 10px 0;
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            white-space: pre-wrap;
            max-height: 200px;
            overflow-y: auto;
          }
          
          body.dark-mode .script-output {
            background-color: rgba(0,0,0,0.3);
          }
          
          .progress {
            height: 8px;
            background-color: rgba(0,0,0,0.1);
          }
          
          .host-header {
            display: flex;
            align-items: center;
            gap: 15px;
          }
          
          .host-status {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background-color: var(--success-color);
          }
          
          .nav-tabs .nav-link {
            color: rgba(0,0,0,0.7);
            border: none;
          }
          
          .nav-tabs .nav-link.active {
            color: var(--primary-color);
            background: transparent;
            border-bottom: 2px solid var(--primary-color);
          }
          
          body.dark-mode .nav-tabs .nav-link {
            color: rgba(255,255,255,0.7);
          }
          
          footer {
            background-color: var(--secondary-color);
            padding: 30px 0;
            margin-top: 50px;
            color: white;
          }
          
          .chart-container {
            height: 350px;
            width: 100%;
            margin: 20px 0;
          }
          
          .port-details {
            margin-top: 15px;
            padding: 15px;
            background-color: rgba(0,0,0,0.03);
            border-radius: 6px;
          }
          
          .port-details-title {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--primary-color);
          }
          
          .port-details-content {
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            white-space: pre-wrap;
            padding: 10px;
            background-color: rgba(0,0,0,0.03);
            border-radius: 4px;
          }
          
          body.dark-mode .port-details-content {
            background-color: rgba(255,255,255,0.05);
          }
          
          .details-toggle {
            cursor: pointer;
            color: var(--primary-color);
            font-size: 0.85rem;
            margin-top: 5px;
            display: inline-block;
          }
          
          .details-toggle i {
            transition: transform 0.3s;
          }
          
          .collapsed .details-toggle i {
            transform: rotate(-90deg);
          }
          
          @media (max-width: 768px) {
            .overview-cards {
              grid-template-columns: 1fr;
            }
            
            .chart-container {
              height: 280px;
            }
            
            .port-badge {
              width: auto;
              padding: 3px 8px;
            }
          }
        </style>
      </head>
      <body>
        <!-- 导航栏 -->
        <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
          <div class="container">
            <a class="navbar-brand" href="#">
              <i class="fas fa-shield-alt me-2"></i>VPGAME 安全报告
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
              <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
              <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                  <a class="nav-link" href="#summary"><i class="fas fa-chart-pie me-1"></i>概览</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#scannedhosts"><i class="fas fa-server me-1"></i>主机</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#onlinehosts"><i class="fas fa-network-wired me-1"></i>在线主机</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#openservices"><i class="fas fa-plug me-1"></i>服务</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="https://kali-linux.netlify.app" target="_blank">
                    <i class="fas fa-external-link-alt me-1"></i>Kali Blog
                  </a>
                </li>
                <!-- 主题切换按钮 -->
                <li class="nav-item">
                  <a class="nav-link" id="theme-toggle" href="#">
                    <i class="fas fa-moon"></i>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </nav>

        <div class="container">
          <!-- 扫描概览 -->
          <div id="summary" class="target mb-5">
            <div class="d-flex justify-content-between align-items-center mb-4">
              <h2 class="mb-0">扫描概览</h2>
              <div class="text-end">
                <div class="text-muted">报告生成时间: <xsl:value-of select="/nmaprun/runstats/finished/@timestr"/></div>
              </div>
            </div>
            
            <!-- 美化后的概览卡片 -->
            <div class="overview-cards">
              <div class="overview-card">
                <div class="card-icon">
                  <i class="fas fa-laptop"></i>
                </div>
                <div class="stat-value"><xsl:value-of select="count(/nmaprun/host)"/></div>
                <div class="stat-label">扫描主机数</div>
                <div class="trend">全部设备</div>
              </div>
              
              <div class="overview-card">
                <div class="card-icon">
                  <i class="fas fa-wifi"></i>
                </div>
                <div class="stat-value"><xsl:value-of select="count(/nmaprun/host[status/@state='up'])"/></div>
                <div class="stat-label">在线主机</div>
                <div class="trend">活动设备</div>
              </div>
              
              <div class="overview-card">
                <div class="card-icon">
                  <i class="fas fa-plug"></i>
                </div>
                <xsl:variable name="tcpPorts" select="count(/nmaprun/host/ports/port[@protocol='tcp' and state/@state='open'])"/>
                <xsl:variable name="udpPorts" select="count(/nmaprun/host/ports/port[@protocol='udp' and state/@state='open'])"/>
                <div class="stat-value"><xsl:value-of select="$tcpPorts + $udpPorts"/></div>
                <div class="stat-label">开放端口</div>
                <div class="trend">TCP: <xsl:value-of select="$tcpPorts"/> | UDP: <xsl:value-of select="$udpPorts"/></div>
              </div>
              
              <div class="overview-card">
                <div class="card-icon">
                  <i class="fas fa-cogs"></i>
                </div>
                <xsl:variable name="services" select="count(/nmaprun/host/ports/port/service)"/>
                <div class="stat-value"><xsl:value-of select="$services"/></div>
                <div class="stat-label">检测到服务</div>
                <div class="trend">运行中服务</div>
              </div>
            </div>
            
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">扫描详情</h3>
              </div>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-6">
                    <div class="mb-3">
                      <label class="form-label text-muted">Nmap 版本:</label>
                      <div class="fw-bold"><xsl:value-of select="/nmaprun/@version"/></div>
                    </div>
                    <div class="mb-3">
                      <label class="form-label text-muted">扫描命令:</label>
                      <div class="fw-bold"><xsl:value-of select="/nmaprun/@args"/></div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="mb-3">
                      <label class="form-label text-muted">开始时间:</label>
                      <div class="fw-bold"><xsl:value-of select="/nmaprun/@startstr"/></div>
                    </div>
                    <div class="mb-3">
                      <label class="form-label text-muted">结束时间:</label>
                      <div class="fw-bold"><xsl:value-of select="/nmaprun/runstats/finished/@timestr"/></div>
                    </div>
                  </div>
                </div>
                
                <div class="mt-4">
                  <h5 class="mb-3">端口状态分布</h5>
                  
                  <!-- 在XSLT中计算端口统计数据 -->
                  <xsl:variable name="totalPorts" select="count(/nmaprun/host/ports/port)"/>
                  <xsl:variable name="openPorts" select="count(/nmaprun/host/ports/port[state/@state='open'])"/>
                  <xsl:variable name="filteredPorts" select="count(/nmaprun/host/ports/port[state/@state='filtered'])"/>
                  <xsl:variable name="closedPorts" select="count(/nmaprun/host/ports/port[state/@state='closed'])"/>
                  
                  <div id="port-distribution-chart" class="chart-container"></div>
                  
                  <!-- 将端口统计数据存储在隐藏字段中 -->
                  <div id="port-stats" 
                       data-open="{$openPorts}" 
                       data-filtered="{$filteredPorts}" 
                       data-closed="{$closedPorts}"
                       style="display:none;"></div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- 主机信息 -->
          <div id="scannedhosts" class="target mb-5">
            <h2 class="mb-4">主机信息</h2>
            
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">扫描主机列表</h3>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="table-overview" class="table table-hover" style="width:100%">
                    <thead>
                      <tr>
                        <th>状态</th>
                        <th>IP地址</th>
                        <th>主机名</th>
                        <th>开放端口</th>
                        <th>服务</th>
                      </tr>
                    </thead>
                    <tbody>
                      <xsl:choose>
                        <xsl:when test="/nmaprun/runstats/hosts/@down > 1024">
                          <xsl:for-each select="/nmaprun/host[status/@state='up']">
                            <xsl:call-template name="host-row"/>
                          </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:for-each select="/nmaprun/host">
                            <xsl:call-template name="host-row"/>
                          </xsl:for-each>
                        </xsl:otherwise>
                      </xsl:choose>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          
          <!-- 在线主机详情 -->
          <div id="onlinehosts" class="target mb-5">
            <h2 class="mb-4">在线主机详情</h2>
            
            <xsl:for-each select="/nmaprun/host[status/@state='up']">
              <div class="card">
                <div class="card-header">
                  <div class="host-header">
                    <span class="host-status"></span>
                    <h3 class="card-title mb-0">
                      <xsl:value-of select="address/@addr"/>
                      <xsl:if test="count(hostnames/hostname) > 0">
                        <span class="text-muted ms-2">(<xsl:value-of select="hostnames/hostname/@name"/>)</span>
                      </xsl:if>
                    </h3>
                  </div>
                </div>
                <div class="card-body">
                  <xsl:if test="count(hostnames/hostname) > 0">
                    <div class="mb-4">
                      <h5 class="mb-3"><i class="fas fa-tag me-2"></i>主机名</h5>
                      <div class="d-flex flex-wrap gap-2">
                        <xsl:for-each select="hostnames/hostname">
                          <span class="service-tag">
                            <xsl:value-of select="@name"/>
                            <span class="text-muted ms-2">(<xsl:value-of select="@type"/>)</span>
                          </span>
                        </xsl:for-each>
                      </div>
                    </div>
                  </xsl:if>
                  
                  <h5 class="mb-3"><i class="fas fa-door-open me-2"></i>端口信息</h5>
                  <div class="table-responsive">
                    <table class="table table-bordered">
                      <thead>
                        <tr>
                          <th>端口</th>
                          <th>状态</th>
                          <th>服务</th>
                          <th>组件</th>
                          <th>版本</th>
                          <th>详细信息</th>
                        </tr>
                      </thead>
                      <tbody>
                        <xsl:for-each select="ports/port">
                          <tr>
                            <td>
                              <span class="port-badge">
                                <xsl:attribute name="class">
                                  <xsl:choose>
                                    <xsl:when test="state/@state = 'open'">port-badge port-open</xsl:when>
                                    <xsl:when test="state/@state = 'filtered'">port-badge port-filtered</xsl:when>
                                    <xsl:otherwise>port-badge port-closed</xsl:otherwise>
                                  </xsl:choose>
                                </xsl:attribute>
                                <xsl:value-of select="@portid"/>/<xsl:value-of select="@protocol"/>
                              </span>
                            </td>
                            <td>
                              <span>
                                <xsl:attribute name="class">
                                  <xsl:choose>
                                    <xsl:when test="state/@state = 'open'">text-success</xsl:when>
                                    <xsl:when test="state/@state = 'filtered'">text-warning</xsl:when>
                                    <xsl:otherwise>text-secondary</xsl:otherwise>
                                  </xsl:choose>
                                </xsl:attribute>
                                <xsl:value-of select="state/@state"/>
                              </span>
                            </td>
                            <td>
                              <xsl:value-of select="service/@name"/>
                              <xsl:if test="service/@tunnel">
                                <span class="badge bg-info ms-2">tunnel</span>
                              </xsl:if>
                            </td>
                            <td><xsl:value-of select="service/@product"/></td>
                            <td><xsl:value-of select="service/@version"/></td>
                            <td>
                              <xsl:if test="service/@extrainfo">
                                <div><small><xsl:value-of select="service/@extrainfo"/></small></div>
                              </xsl:if>
                              <xsl:if test="service/cpe">
                                <div><small class="text-muted">CPE: <xsl:value-of select="service/cpe"/></small></div>
                              </xsl:if>
                            </td>
                          </tr>
                          
                          <!-- 脚本输出详细信息 -->
                          <xsl:if test="script">
                            <tr>
                              <td colspan="6">
                                <div class="port-details">
                                  <xsl:for-each select="script">
                                    <div>
                                      <div class="port-details-title">
                                        <xsl:value-of select="@id"/>
                                      </div>
                                      <div class="port-details-content">
                                        <xsl:value-of select="@output"/>
                                      </div>
                                    </div>
                                  </xsl:for-each>
                                </div>
                              </td>
                            </tr>
                          </xsl:if>
                        </xsl:for-each>
                      </tbody>
                    </table>
                  </div>
                  
                  <xsl:if test="count(hostscript/script) > 0">
                    <h5 class="mt-4 mb-3"><i class="fas fa-terminal me-2"></i>主机脚本输出</h5>
                    <xsl:for-each select="hostscript/script">
                      <div class="mb-3">
                        <strong><xsl:value-of select="@id"/>:</strong>
                        <div class="script-output">
                          <xsl:value-of select="@output"/>
                        </div>
                      </div>
                    </xsl:for-each>
                  </xsl:if>
                </div>
              </div>
            </xsl:for-each>
          </div>
          
          <!-- 服务信息 -->
          <div id="openservices" class="target mb-5">
            <h2 class="mb-4">服务信息</h2>
            
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">检测到的服务</h3>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="table-services" class="table table-hover" style="width:100%">
                    <thead>
                      <tr>
                        <th>服务名称</th>
                        <th>端口</th>
                        <th>主机</th>
                        <th>组件</th>
                        <th>版本</th>
                        <th>风险</th>
                      </tr>
                    </thead>
                    <tbody>
                      <xsl:for-each select="/nmaprun/host">
                        <xsl:for-each select="ports/port[state/@state='open']">
                          <tr>
                            <td>
                              <xsl:value-of select="service/@name"/>
                              <xsl:if test="service/@tunnel">
                                <span class="badge bg-info ms-2">tunnel</span>
                              </xsl:if>
                            </td>
                            <td><xsl:value-of select="@portid"/>/<xsl:value-of select="@protocol"/></td>
                            <td>
                              <xsl:value-of select="../../address/@addr"/>
                              <xsl:if test="count(../../hostnames/hostname) > 0">
                                <div class="text-muted small"><xsl:value-of select="../../hostnames/hostname/@name"/></div>
                              </xsl:if>
                            </td>
                            <td><xsl:value-of select="service/@product"/></td>
                            <td><xsl:value-of select="service/@version"/></td>
                            <td>
                              <div class="vulnerability-indicator"></div>
                              <div class="text-end small mt-1">
                                <xsl:choose>
                                  <xsl:when test="contains(service/@version, '2.4')">
                                    <span class="text-warning">中风险</span>
                                  </xsl:when>
                                  <xsl:when test="contains(service/@version, '1.0')">
                                    <span class="text-danger">高风险</span>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <span class="text-success">低风险</span>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </div>
                            </td>
                          </tr>
                        </xsl:for-each>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <!-- 页脚 -->
        <footer>
          <div class="container">
            <div class="row">
              <div class="col-md-6 mb-3 mb-md-0">
                <h5><i class="fas fa-shield-alt me-2"></i>安全报告</h5>
                <p class="mb-0">本报告由神器nmap扫描生成</p>
              </div>
              <div class="col-md-6 text-md-end">
                <div class="mb-2">
                  <span class="text-light">扫描时间: </span>
                  <span><xsl:value-of select="/nmaprun/@startstr"/> - <xsl:value-of select="/nmaprun/runstats/finished/@timestr"/></span>
                </div>
                <div>
                  <a href="https://kali-linux.netlify.app" class="text-white text-decoration-none me-3">
                    <i class="fas fa-globe me-1"></i>Kali Blog
                  </a>
                  <a href="mailto:kukuqi666@gmail.com" class="text-white text-decoration-none">
                    <i class="fas fa-envelope me-1"></i>kukuqi666@gmail.com
                  </a>
                </div>
              </div>
            </div>
            <hr class="my-4 bg-light opacity-10"/>
            <div class="text-center small text-light opacity-75">
              © Kali Linux 报告由 Nmap <xsl:value-of select="/nmaprun/@version"/> 生成
            </div>
          </div>
        </footer>
        
        <!-- 脚本 -->
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
        
        <script>
          <![CDATA[
          $(document).ready(function() {
            // 修复平滑滚动错误
            $('a[href^="#"]').on('click', function(e) {
              e.preventDefault();
              var target = this.hash;
              if (target) {
                var $target = $(target);
                if ($target.length) {
                  $('html, body').animate({
                    scrollTop: $target.offset().top - 60
                  }, 800, 'swing');
                }
              }
            });
            
            // 主题切换功能
            const themeToggle = $('#theme-toggle');
            const themeIcon = themeToggle.find('i');
            
            // 检查本地存储中的主题设置
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme === 'dark') {
              $('body').addClass('dark-mode');
              themeIcon.removeClass('fa-moon').addClass('fa-sun');
            }
            
            // 主题切换事件
            themeToggle.on('click', function() {
              $('body').toggleClass('dark-mode');
              
              if ($('body').hasClass('dark-mode')) {
                themeIcon.removeClass('fa-moon').addClass('fa-sun');
                localStorage.setItem('theme', 'dark');
              } else {
                themeIcon.removeClass('fa-sun').addClass('fa-moon');
                localStorage.setItem('theme', 'light');
              }
            });
            
            // 初始化主机表格
            $('#table-overview').DataTable({
              language: {
                "sProcessing": "处理中...",
                "sLengthMenu": "显示 _MENU_ 项结果",
                "sZeroRecords": "没有匹配结果",
                "sInfo": "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
                "sInfoEmpty": "显示第 0 至 0 项结果，共 0 项",
                "sInfoFiltered": "(由 _MAX_ 项结果过滤)",
                "sSearch": "搜索:",
                "sEmptyTable": "表中数据为空",
                "oPaginate": {
                  "sFirst": "首页",
                  "sPrevious": "上页",
                  "sNext": "下页",
                  "sLast": "末页"
                }
              },
              order: [[1, 'asc']],
              columnDefs: [
                { orderable: false, targets: [0, 3, 4] }
              ]
            });
            
            // 初始化服务表格
            $('#table-services').DataTable({
              language: {
                "sProcessing": "处理中...",
                "sLengthMenu": "显示 _MENU_ 项结果",
                "sZeroRecords": "没有匹配结果",
                "sInfo": "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
                "sInfoEmpty": "显示第 0 至 0 项结果，共 0 项",
                "sInfoFiltered": "(由 _MAX_ 项结果过滤)",
                "sSearch": "搜索:",
                "sEmptyTable": "表中数据为空",
                "oPaginate": {
                  "sFirst": "首页",
                  "sPrevious": "上页",
                  "sNext": "下页",
                  "sLast": "末页"
                }
              },
              order: [[0, 'asc']]
            });
            
            // 初始化端口分布图表
            const chartDom = document.getElementById('port-distribution-chart');
            if (chartDom) {
              const myChart = echarts.init(chartDom);
              
              // 从隐藏字段获取端口统计数据
              const portStats = $('#port-stats');
              const openPorts = parseInt(portStats.data('open')) || 0;
              const filteredPorts = parseInt(portStats.data('filtered')) || 0;
              const closedPorts = parseInt(portStats.data('closed')) || 0;
              
              // 计算总数
              const totalPorts = openPorts + filteredPorts + closedPorts;
              
              const option = {
                tooltip: {
                  trigger: 'item',
                  formatter: function(params) {
                    const value = params.value;
                    const percent = totalPorts > 0 ? ((value / totalPorts) * 100).toFixed(1) : 0;
                    return `${params.name}: ${value} (${percent}%)`;
                  }
                },
                legend: {
                  orient: 'vertical',
                  right: 10,
                  top: 'center',
                  data: ['开放端口', '过滤端口', '关闭端口']
                },
                series: [
                  {
                    name: '端口分布',
                    type: 'pie',
                    radius: ['50%', '70%'],
                    avoidLabelOverlap: false,
                    itemStyle: {
                      borderRadius: 10,
                      borderColor: '#fff',
                      borderWidth: 2
                    },
                    label: {
                      show: false,
                      position: 'center'
                    },
                    emphasis: {
                      label: {
                        show: true,
                        fontSize: '18',
                        fontWeight: 'bold'
                      }
                    },
                    labelLine: {
                      show: false
                    },
                    data: [
                      { value: openPorts, name: '开放端口', itemStyle: { color: '#2ecc71' } },
                      { value: filteredPorts, name: '过滤端口', itemStyle: { color: '#f39c12' } },
                      { value: closedPorts, name: '关闭端口', itemStyle: { color: '#95a5a6' } }
                    ]
                  }
                ]
              };
              
              myChart.setOption(option);
              
              // 响应窗口大小变化
              window.addEventListener('resize', function() {
                myChart.resize();
              });
            }
          });
          ]]>
        </script>
      </body>
    </html>
  </xsl:template>
  
  <!-- 主机行模板 -->
  <xsl:template name="host-row">
    <tr>
      <td>
        <span class="badge">
          <xsl:attribute name="class">
            <xsl:choose>
              <xsl:when test="status/@state='up'">badge bg-success</xsl:when>
              <xsl:otherwise>badge bg-secondary</xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:value-of select="status/@state"/>
        </span>
      </td>
      <td><xsl:value-of select="address/@addr"/></td>
      <td>
        <xsl:choose>
          <xsl:when test="hostnames/hostname/@name">
            <xsl:value-of select="hostnames/hostname/@name"/>
          </xsl:when>
          <xsl:otherwise>-</xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:value-of select="count(ports/port[state/@state='open' and @protocol='tcp'])"/> TCP,
        <xsl:value-of select="count(ports/port[state/@state='open' and @protocol='udp'])"/> UDP
      </td>
      <td>
        <xsl:variable name="services" select="ports/port/service/@name"/>
        <xsl:if test="$services">
          <xsl:for-each select="ports/port[generate-id() = generate-id(key('services', service/@name)[1])]">
            <span class="service-tag"><xsl:value-of select="service/@name"/></span>
          </xsl:for-each>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
